<?php

namespace Import\ApiBundle\Services\Import;


use Import\ApiBundle\Entity\IncomeTax;
use Import\ApiBundle\Entity\IncomeTaxRate;

class ImportIncomeTaxRates extends ImportMainService
{
    protected $url = 'http://www.wskazniki.pl/?doc_id=189592&iid=4635';

    protected $columns = array("Ponad","Do","Podatek");

    protected $yearOfTaxes = 0;

    public function import()
    {
        $this->type = 'ImportIncomeTaxRates';
        $data = $this->getIncomeTaxTableAndYearFromPage($this->url,$this->columns);

        $this->yearOfTaxes = $data->year;
        $data = $data->res;

        foreach($data as $id => $row)
        {
            if($this->validRow($row))
            {
                $row = $this->addDataToRow($row);
                if(empty($row))
                {
                    $this->addError(3,$data[$id],$this->type);
                    unset($data[$id]);
                }
                else
                {
                    $data[$id] = $row;
                }
            }
            else
            {
                unset($data[$id]);
            }
        }
        $data = $this->addCITRow($data);
        $count = $this->save($data);
        $this->viewErrors();

        return array('count' => $count);
    }

    protected function validRow($row)
    {
        $valid = true;

        foreach($this->columns as $column)
        {
            if(!isset($column) || $row[$column] == '')
            {
                $valid = false;
                $this->addError(1,$column,$this->type);
            }
        }

        return $valid;
    }

    protected function addDataToRow($row)
    {
        for($i = 0; $i < 3; $i++)
        {
            $data = $row[$this->columns[$i]];
            if($data == '&nbsp;')
            {
                $data = 0;
            }
            $data = str_replace('&nbsp;', 0, $data);
            $data = str_replace('zł','',$data);
            $data = str_replace(',','.',$data);

            $data = trim($data);

            $row[$this->columns[$i]] = $data;
        }

        return $row;
    }

    protected function addCITRow($data)
    {
        $row = array(
            $this->columns[0] => 0,
            $this->columns[1] => 0,
            $this->columns[2] => 19
        );
        $data[] = $row;
        return $data;
    }

    protected function save($data)
    {
        $incomeTaxesForYear = $this->getDoctrine()->getRepository('ImportApiBundle:IncomeTaxRate')->findOneBy(array('year' => $this->yearOfTaxes));

        if(empty($incomeTaxesForYear))
        {
            $incomeTaxesForYear = new IncomeTaxRate();
        }

        $incomeTaxesForYear->setPitTreshold($data[0]['Do']);
        $incomeTaxesForYear->setPitLowerSectionDescription($data[0]['Podatek']);
        $incomeTaxesForYear->setPitHigherSectionDescription($data[1]['Podatek']);
        $incomeTaxesForYear->setCitPercent($data[2]['Podatek']);
        $incomeTaxesForYear->setYear($this->yearOfTaxes);
        $incomeTaxesForYear->setCreateAt(new \DateTime());

        $this->getDoctrine()->getEntityManager()->persist($incomeTaxesForYear);
        $this->getDoctrine()->getEntityManager()->flush();

        return 1;
    }
}